#!/usr/bin/perl

# define
use constant STOP => 'stopwords.inc';

# include
use strict;
require 'subroutines.pl';

# slurp up the corpus
my @corpus = ();
foreach my $book ( &corpus ) { push @corpus, &index( $book, &slurp_words( STOP )) }

# build dictionary
my %dictionary = ();
foreach my $book ( @corpus ) {

	foreach my $word ( keys %$book ) { $dictionary{ $word } = $dictionary{ $word } + $$book{ $word } }

}

# display header
for ( my $i = 0; $i <= $#corpus; $i++ ) { print "\tB", $i + 1 }
print "\tT\tWord\n\n";

# process each word; sort according to taste
foreach my $word ( sort { $dictionary{ $b } <=> $dictionary{ $a } } keys %dictionary ) {

	next if ( $word =~ /[,.?!:;()\-]/ );
	foreach my $book ( @corpus ) {
	
		my $count = 0;
		if ( $$book{ $word } ) { $count = $$book{ $word } }
		print "\t$count";
	
	}
	print "\t$dictionary{ $word }";
	print "\t$word\n";

}

# done
exit;
