#!/usr/bin/perl

# main-menu.pl 

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-11 - wrote pod


=head1 NAME

main-menu.pl - the root script to a terminal-based system for doing I/O against a MyLibrary database

=head1 DESCRIPTION

This script is the root of a terminal-based system for doing I/O against a MyLibrary database. It doesn't do much but query the user for the type of data they want to manage and branch to the appropriate script.

=head1 SEE ALSO

manage-terms.pl, manage-resources.pl, manage-locations.pl, manage-facets.pl, subroutines.pl

=head1 AUTHOR

Eric Lease Morgan

=cut

# set of common functions used throughout the system
require 'subroutines.pl';

# initialize menu choice
my $choice eq '';

do {

	# display an introduction
	&clearScreen;
	print "\nUse the program to maintain MyLibrary.\n\n";
	
	# menu
	print "Main menu\n";
	print "=========\n";
	print <<EOM;
Manage [f]acets
Manage [t]erms
Manage [l]ocation types
Manage [r]esources
  
[q]uit
  
EOM
	print "Which one? "; chop ($choice = <STDIN>);

	# branch according to chioice; create a resource
	if    ($choice eq 'f')  { system './manage-facets.pl' }
	elsif ($choice eq 't' ) { system './manage-terms.pl' }
	elsif ($choice eq 'l' ) { system './manage-locations.pl' }
	elsif ($choice eq 'r' ) { system './manage-resources.pl' }
	elsif ($choice eq 'q' ) { print  "\nBye, bye\n" }
	else                    { print  "Unknown choice: $choice. Returning to menu.\n" }

} until $choice eq 'q';
