#!/usr/bin/perl

# manage-terms.pl - a sample MyLibrary script to create, find, edit, and delete terms

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-11 - wrote pod
# 2003-10-10 - first cut (embarrassing)


=head1 NAME

manage-terms.pl - create, find, edit, and delete MyLibrary term values

=head1 DESCRIPTION

The purpose of this script is to create, find, edit, and delete MyLibrary term values.

Like manage-facets.pl, this script is a good candidate for reading if you are just starting to program with MyLibrary. The only extra thing in this script compared to manage-facets.pl is the necessity to associate terms with a parent facet. Thus, this script contains methods for creating facet objects and returning values from them.

=head1 SEE ALSO

manage-facets.pl, subroutines.pl

=head1 AUTHOR

Eric Lease Morgan

=cut
# include the necessary modules
use lib '../lib/';
use MyLibrary::Facet;
use MyLibrary::Term;
use strict;
require 'subroutines.pl';

# display an introduction
&clearScreen;
print "\nUse this program to create and maintain MyLibrary terms.\n\n";

# initialize menu choice
my $choice eq '';

do {

	# display menu
	print "Terms main menu\n";
	print "===============\n";
	print <<EOM;
[c]reate a term
[f]ind all terms
display [o]ne term
[e]dit a term
[d]elete a term
  
[q]uit
  
EOM
	print "Which one? "; chop ($choice = <STDIN>);
	
	# branch according to chioice; create a term
	if ($choice eq 'c') {
	
		# get the input
		print "What is the name of this new term? "; chop (my $name = <STDIN>);
		print "Please describe this term. "; chop (my $note = <STDIN>);
		
		# create the object, fill it, and save it
		my $term = MyLibrary::Term->new;
		$term->term_name($name);
		$term->term_note($note);

		# get the associated facet
		&listAllFacets;
		print "Select a parent facet id. "; chop (my $id = <STDIN>);
		$term->facet_id($id);

		# save and echo
		$term->commit;
		&listOneTerm ($term->term_id);
	
	}
	
	# find all terms
	elsif ($choice eq 'f' ) { &listAllTerms	}
	
	# display one term
	elsif ($choice eq 'o' ) {
	
		print "What is the ID of the term you want to display? "; chop (my $id = <STDIN>);
		&listOneTerm($id);
		
	}
	
	# edit a term
	elsif ($choice eq 'e' ) {
	
		# get the term to edit
		print "What is the ID of the term you want to edit? "; chop (my $id = <STDIN>);
		
		# get it
		my $term = MyLibrary::Term->new (id => $id);
		
		# check for success
		if ($term ne undef) {
		
			# get new input
			print "Change the name of the term from " . $term->term_name . " to: "; chop (my $name = <STDIN>);
			print "Change the note of the term from " . $term->term_note . " to: "; chop (my $note = <STDIN>);
			&listAllFacets;
			print "Change the facet of the term from " . $term->facet_id . " to: "; chop (my $facet = <STDIN>);
			
			# update the object
			$term->term_name($name);
			$term->term_note($note);
			$term->facet_id($facet);
			$term->commit;

			# echo the result
			&listOneTerm ($term->term_id);
			
		}
		
		# error
		else { print "The id, $id, does not point to a valid term. Try find.\n" }
	
	}
	
	# delete a term
	elsif ($choice eq 'd' ) {
	
		# get the term to delete
		print "What is the ID of the term you want to delete? "; chop (my $id = <STDIN>);
		
		# get it
		my $term = MyLibrary::Term->new(id => $id);
		
		# check for success
		if ($term ne undef) {
		
			# display 
			print "\nTerm:\n";
			print "    id = " . $term->term_id . "\n";
			print "  name = " . $term->term_name . "\n";
			print "  note = " . $term->term_note . "\n";
			print "\n";

			# confirm
			print "Do you really want to delete this record [y/n]? "; chop (my $reply = <STDIN>);
			
			# check reply
			if ($reply eq 'y') {
			
				# delete it
				$term->delete;
				print "\nTerm deleted.\n\n";
				
			}
			
		}
		
		# error
		else { print "The id, $id, does not point to a valid term. Try find.\n" }

	
	}
	
	# quit
	elsif ($choice eq 'q' ) { print "\nBye, bye\n" }
	
	else { print "Unknown choice: $choice. Returning to menu.\n" }
	
} until $choice eq 'q';


