
# common subroutines for example MyLibrary CGI scripts

# Eric Lease Morgan <emorgan@nd.edu>

# 2004-10-27 - first cut



sub transform_one_article {

	my $root     = $_[0];
	my $filename = $_[1];
	my $sheet    = $_[2];
	my $article  = $_[3];
		
	# create the necessary objects and transform
	my $parser     = XML::LibXML->new;
	my $xslt       = XML::LibXSLT->new;
	my $source     = $parser->parse_file($root . $article->article_path() . $article->article_filename()) or croak $!;
	my $style      = $parser->parse_string($sheet->stylesheet_content) or croak $!;
	my $stylesheet = $xslt->parse_stylesheet($style) or croak $!;
	my $results    = $stylesheet->transform($source) or croak $!;

	# save
	open (OUTPUT, '> ' . $root . $article->article_path . $filename);
	print OUTPUT $stylesheet->output_string($results);
	close OUTPUT;

	# done
	return '<a href="' . $article->article_path . $filename . '">' . $article->article_title . '</a>.';
	
}


sub build_one_article {
		
		# get the article
		my $article = shift;

		# build the author list; but WATCH OUT, it isn't all about me
		my @author_ids = $article->author_ids;
		my $authors;
		my $author_email;
		foreach (@author_ids) {
		
			my $author = Musings::Author->new(id => $_);
			$authors .= $author->first_name . ' ' . $author->middle_name . ' ' . $author->last_name;
			$author_email .= $author->email;
		
		}
		
		# build a subject list
		my @subject_ids = $article->subject_ids;
		my $subjects = '<list>';
		foreach (@subject_ids) {
		
			my $subject = Musings::Subject->new(id => $_);
			$subjects .= '<item>' . $subject->subject_term . '</item>';
			
		}
		$subjects .= '</list>';
		
		# build the URL of this page
		my $xml_url = HOST . $article->article_path . $article->article_filename;
		
		# get the template and fill it up
		my $template = Musings::Template->new(id => $article->template_id);
		my $xml = $template->template_content;
		$xml =~ s/##ABSTRACT##/$article->article_note/e;
		$xml =~ s/##AUTHOR##/$authors/e;
		$xml =~ s/##BODY##/$article->article_content/e;
		$xml =~ s/##CHANGES##/$article->article_changes/e;
		$xml =~ s/##DATECREATED##/$article->article_date/e;
		$xml =~ s/##EMAIL##/$author_email/e;
		$xml =~ s/##IDNO##/$article->article_id/e;
		$xml =~ s/##SOURCE##/$article->article_source/e;
		$xml =~ s/##SUBJECTS##/$subjects/e;
		$xml =~ s/##TITLE##/$article->article_title/e;
		$xml =~ s/##XMLURL##/$xml_url/e;
		
		# save
		open (XML, '> ' . ROOT . $article->article_path . $article->article_filename);
		print XML $xml;
		close XML;
		
		# done
		return '<a href="' . $article->article_path . $article->article_filename . '">' . $article->article_title . '</a>';

}


sub get_all_authors {

	# buildlist of facet/terms
	my @values;
	my %labels;
	foreach (Musings::Author->get_authors()) {
	
		# this can cause problems (crash) if each term is not associated with a facet!
		my $author_id = $_->author_id;
		my $author = Musings::Author->new(id => $author_id);
		push @values, $_->author_id;
		$labels{$_->author_id} = $author->first_name . ' ' . $author->middle_name . ' ' . $author->last_name ;
		
	}
		
	# done
	return \@values, \%labels;

}


sub get_all_subjects {

	# buildlist of facet/terms
	my @values;
	my %labels;
	foreach (Musings::Subject->get_subjects()) {
	
		# this can cause problems (crash) if each term is not associated with a facet!
		my $subject_id = $_->subject_id;
		my $subject = Musings::Subject->new(id => $subject_id);
		push @values, $_->subject_id;
		$labels{$_->subject_id} = $subject->subject_term;
		
	}
		
	# done
	return \@values, \%labels;

}

sub get_all_templates {

	# buildlist of facet/terms
	my @values;
	my %labels;
	foreach (Musings::Template->get_templates()) {
	
		# this can cause problems (crash) if each term is not associated with a facet!
		my $template_id = $_->template_id;
		my $template = Musings::Template->new(id => $template_id);
		push @values, $_->template_id;
		$labels{$_->template_id} = $template->template_name;
		
	}
		
	# done
	return \@values, \%labels;

}



sub list_one_article {

	# get the input
	my %opts  = @_;
	
	# create an article
	my $article = Musings::Article->new(id => $opts{id});
	
	# build the list
	my $cgi = CGI->new;
	my $list = $cgi->li('ID - ' . $article->article_id);
	
	if ($opts{style} eq 'full') {
	
		if ($article->article_path) { $list .= $cgi->li('Path - ' . $article->article_path) }
		if ($article->article_filename) { $list .= $cgi->li('Filename - ' . $article->article_filename) }
		if ($article->template_id) {
		
			my $template = Musings::Template->new(id => $article->template_id);
			$list .= $cgi->li('Template - ' . $template->template_name . ' (' . $template->template_id . ')');
			
		}
		
		if ($article->author_ids) {
		
			my $authors;
			foreach ($article->author_ids) {
			
				my $author = Musings::Author->new(id => $_);
				$authors .= $author->first_name . ' ' . $author->middle_name . ' ' . $author->last_name . '; ';
			
			}
			
			$list .= $cgi->li('Author(s) - ' . $authors)
			
		}
		
		if ($article->article_date) { $list .= $cgi->li('Date created - ' . $article->article_date) }
		if ($article->article_note) { $list .= $cgi->li('Abstract - ' . &escape($article->article_note)) }
		if ($article->article_source) { $list .= $cgi->li('Source - ' . &escape($article->article_source)) }
		if ($article->article_changes) { $list .= $cgi->li('Changes - ' . &escape($article->article_changes)) }
		if ($article->article_content) { $list .= $cgi->li('Content' . $cgi->pre(&escape($article->article_content))) }
		if ($article->subject_ids) {
		
			my $subjects;
			foreach ($article->subject_ids) {
			
				my $subject = Musings::Subject->new(id => $_);
				$subjects .= $subject->subject_term . '; ';
			
			}
			
			$list .= $cgi->li('Subjects(s) - ' . $subjects)
			
		}
		
	
	}

	$list = $cgi->ul({-class=>'detaillist'}, $list);
	$list = $cgi->li($article->article_title . $list);

	# done
	return $list;
	
}


sub footer {

	# return a simple footer
	return <<EOF;
	</div>
	<p style='text-align: right; font-size: small;'>Managed with Musings.pm</p>
	</div>
	</body>
</html>
EOF

}


sub escape {
    my $text = shift;
    $text =~ s/&/&amp;/g;
    $text =~ s/</&lt;/g;
    $text =~ s/>/&gt;/g;
    #$text = $charset->to_utf8($text);
    return($text);
}

sub today {
	
		my $date = DateTime->now->ymd;
		return $date;

}


# return true or die
1;