use Test::More tests => 15;
use strict;

# use the module
use_ok('Musings::Stylesheet');

# create object
my $stylesheet = Musings::Stylesheet->new();
isa_ok($stylesheet, "Musings::Stylesheet");

# stylesheet term
$stylesheet->stylesheet_name('origami');
is($stylesheet->stylesheet_name(), 'origami', 'set stylesheet_name()');

# stylesheet note
$stylesheet->stylesheet_note('the art of folding paper');
is($stylesheet->stylesheet_note(), 'the art of folding paper', 'set stylesheet_note()');

# stylesheet content
$stylesheet->stylesheet_content('the art of folding paper');
is($stylesheet->stylesheet_content(), 'the art of folding paper', 'set stylesheet_content()');

# commit
is($stylesheet->commit(), '1', 'commit()');

# id
my $id = $stylesheet->stylesheet_id();
like ($id, qr/^\d+$/, 'get stylesheet_id()');

# get record based on an id
$stylesheet = Musings::Stylesheet->new(id => $id);
is ($stylesheet->stylesheet_name(), 'origami', 'get stylesheet_name() matches based on id');
is ($stylesheet->stylesheet_note(), 'the art of folding paper', 'get stylesheet_note() matches based on id');
is ($stylesheet->stylesheet_content(), 'the art of folding paper', 'get stylesheet_content() matches based on id');

# update a facet record
$stylesheet->stylesheet_name('Paperfolding');
$stylesheet->stylesheet_note('an art as well a craft');
$stylesheet->stylesheet_content('Eric Lease Morgan');
$stylesheet->commit();
$stylesheet = Musings::Stylesheet->new(id => $id);
is ($stylesheet->stylesheet_name(), 'Paperfolding', 'commit() update');
is ($stylesheet->stylesheet_note(), 'an art as well a craft', 'commit() update');
is ($stylesheet->stylesheet_content(), 'Eric Lease Morgan', 'commit() update');

# get facets
my @s = Musings::Stylesheet->get_stylesheets();
my $stylesheet_count = scalar(@s);
like ($stylesheet_count, qr/^\d+$/, "get_stylesheets() $stylesheet_count found");

# delete a facet record
is ($stylesheet->delete(), '1', 'delete() a facet');
