use Test::More tests => 33;
use strict;

# use the module
use_ok('Musings::Article');

# create object
my $article = Musings::Article->new();
isa_ok($article, "Musings::Article");

# title
$article->article_title('Art and Science of Librarianship');
is($article->article_title(), 'Art and Science of Librarianship', 'set article_title()');


# changes
$article->article_changes('<change>foo bar</change>');
is($article->article_changes(), '<change>foo bar</change>', 'set article_changes()');


# content
$article->article_content('<body>foo bar</body>');
is($article->article_content(), '<body>foo bar</body>', 'set article_content()');


# contributor
$article->article_contributor('Fred Kilgour');
is($article->article_contributor(), 'Fred Kilgour', 'set article_contributor()');


# date
$article->article_date('2004-11-01');
is($article->article_date(), '2004-11-01', 'set article_date()');


# note
$article->article_note('Read this article. It is cool.');
is($article->article_note(), 'Read this article. It is cool.', 'set article_note()');


# path
$article->article_path('/usr/local/apache/htdocs/musings/ebooks/');
is($article->article_path(), '/usr/local/apache/htdocs/musings/ebooks/', 'set article_path()');


# source
$article->article_source('Computers in Libraries 4(3):54-56');
is($article->article_source(), 'Computers in Libraries 4(3):54-56', 'set article_source()');


# filename
$article->article_filename('foobar.xml');
is($article->article_filename(), 'foobar.xml', 'set article_filename()');


# stylesheet_id
$article->stylesheet_id('101');
is($article->stylesheet_id(), '101', 'set stylesheet_id()');


# template_id
$article->template_id('101');
is($article->template_id(), '101', 'set template_id()');


# author ids
my @author_ids = $article->author_ids(1, 2, 3, 4);
is ($#author_ids, '3', 'set author_ids');


# subject ids
my @subject_ids = $article->subject_ids(5, 6, 7);
is ($#subject_ids, '2', 'set subject_ids');


# commit
is($article->commit(), '1', 'commit()');


# id
my $id = $article->article_id();
like ($id, qr/^\d+$/, 'get article_id()');


# get title, changes, content, etc
$article = Musings::Article->new(id => $id);
is($article->article_title(), 'Art and Science of Librarianship', 'get article_name()');
is($article->article_changes(), '<change>foo bar</change>', 'get article_changes()');
is($article->article_content(), '<body>foo bar</body>', 'get article_content()');
is($article->article_contributor(), 'Fred Kilgour', 'get article_contributor()');
is($article->article_date(), '2004-11-01', 'get article_date()');
is($article->article_note(), 'Read this article. It is cool.', 'get article_note()');
is($article->article_path(), '/usr/local/apache/htdocs/musings/ebooks/', 'get article_path()');
is($article->article_source(), 'Computers in Libraries 4(3):54-56', 'get article_source()');
is($article->article_filename(), 'foobar.xml', 'get article_filename()');
is($article->stylesheet_id(), '101', 'get stylesheet_id()');
is($article->template_id(), '101', 'get template_id()');
is($article->author_ids(), '4', 'get author_ids()');
is($article->subject_ids(), '3', 'get subject_ids()');


# get articles
my @articles = Musings::Article->get_articles(sort => 'name');
my $article_count = scalar(@articles);
like ($article_count, qr/^\d+$/, "get_articles() $article_count found");


# get articles by criteria
@articles = Musings::Article->get_articles(value => 'science', field => 'article_title', sort => 'name');
my $a = $articles[0]->article_title();
is ("$a", 'Art and Science of Librarianship', 'get_articles(value, field)');


# delete
is ($article->delete(), '1', 'delete() an article');



